/*!\file:  OptFunc.cpp
 * \brief: "C" code wrapper to matlab objectivefunctionC call
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"

#ifdef _HAVE_MATLAB_
#include "mex.h"
double OptFunc(double scalar, OptArgs* optargs){
	
	/*output: */
	double J;

	mxArray*   inputs[2];
	mxArray*   psearch_scalar=NULL;
	mxArray*   mxJ=NULL;

	psearch_scalar=mxCreateDoubleScalar(scalar);
	inputs[0]=psearch_scalar;
	inputs[1]=optargs->femmodel;

	mexCallMATLAB(1,&mxJ,2,(mxArray**)inputs, optargs->function_name);

	/*extract misfit from mxArray*/
	J=mxGetScalar(mxJ);

	return J;
}
#else
double OptFunc(double scalar, OptArgs* optargs){
	_error_(" not implemented yet");
}
#endif
