/* \file Exceptions.cpp
 * \brief: implementation of the exceptions.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../shared.h"
#include "../../include/include.h"
#ifdef _HAVE_MATLAB_
#include "mex.h"
#endif

ErrorException::ErrorException(const string &what_arg){

	what_str=what_arg;
	file_name="";
	function_name="";
	file_line=0;
}

ErrorException::ErrorException(string what_file,string what_function,int what_line,string what_arg){

	what_str=what_arg;
	file_name=what_file;
	function_name=what_function;
	file_line=what_line;
}

ErrorException::~ErrorException() throw(){
}

const char* ErrorException::what() const throw(){
	return what_str.c_str();
}

void ErrorException::Report(){
	extern int my_rank;

	if (function_name=="" || file_line==0){ //WINDOWS
		printf("%s%s","Error message: ",what());
	}
	else{
		#ifdef _HAVE_MATLAB_
			mexErrMsgTxt(exprintf("\n??? Error using ==> %s at %i\n%s error message: %s\n",
							file_name.c_str(),file_line,function_name.c_str(),what()));
		#else
			printf("\n[%i] ??? Error using ==> %s:%i\n",my_rank,file_name.c_str(),file_line);
			printf("[%i] %s error message: %s\n\n",my_rank,function_name.c_str(),what());
		#endif
	}
	return;
}
