/*!\file IntParam.c
 * \brief: implementation of the IntParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*IntParam constructors and destructor*/
/*FUNCTION IntParam::IntParam(){{{1*/
IntParam::IntParam(){
	return;
}
/*}}}*/
/*FUNCTION IntParam::IntParam(int enum_type,IssmInt value){{{1*/
IntParam::IntParam(int in_enum_type,IssmInt in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION IntParam::~IntParam(){{{1*/
IntParam::~IntParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntParam::Echo {{{1*/
void IntParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION IntParam::DeepEcho{{{1*/
void IntParam::DeepEcho(void){

	printf("IntParam:\n");
	printf("   enum:  %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %i\n",this->value);
}
/*}}}*/
/*FUNCTION IntParam::Id{{{1*/
int    IntParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntParam::MyRank{{{1*/
int    IntParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION IntParam::Marshall{{{1*/
void  IntParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of IntParam: */
	enum_value=IntParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall IntParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION IntParam::MarshallSize{{{1*/
int   IntParam::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION IntParam::Demarshall{{{1*/
void  IntParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION IntParam::ObjectEnum{{{1*/
int IntParam::ObjectEnum(void){

	return IntParamEnum;

}
/*}}}*/
/*FUNCTION IntParam::copy{{{1*/
Object* IntParam::copy() {
	
	return new IntParam(this->enum_type,this->value);

}
/*}}}*/

/*IntParam virtual functions definitions: */
/*FUNCTION IntParam::GetParameterName{{{1*/
void IntParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION IntParam::SetMatlabField{{{1*/
#ifdef _HAVE_MATLAB_
void  IntParam::SetMatlabField(mxArray* dataref){
	
	char* name=NULL;
	this->GetParameterName(&name);
	mxSetField( dataref, 0, name,mxCreateDoubleScalar((double)value));
}
#endif
/*}}}*/
/*FUNCTION IntParam::UnitConversion{{{1*/
void  IntParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
