/*\file matlabio.h
 *\brief: I/O for ISSM in matlab mode
 */

#ifndef _MATLAB_IO_H_
#define _MATLAB_IO_H_

#include "../../objects/objects.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

class DataSet;
class Parameters;

#ifdef _HAVE_MATLAB_
#include <mex.h>
void WriteMatlabData(mxArray** pdataref,DataSet* dataset);
void WriteMatlabData(mxArray** pdataref,Matrix* matrix);
void WriteMatlabData(mxArray** pdataref,double* matrix, int M,int N);
void WriteMatlabData(mxArray** pdataref,int*    matrix, int M,int N);
void WriteMatlabData(mxArray** pdataref,Vector* vector);
void WriteMatlabData(mxArray** pdataref,double* vector, int M);
void WriteMatlabData(mxArray** pdataref,int integer);
void WriteMatlabData(mxArray** pdataref,bool boolean);
void WriteMatlabData(mxArray** pdataref,double scalar);
void WriteMatlabData(mxArray** pdataref,char* string);
void WriteMatlabData(DataHandle* pdataref,Parameters* parameters);

void FetchMatlabData(DataSet** pdataset,const mxArray* dataref);
void FetchMatlabData(double** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchMatlabData(double** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
void FetchMatlabData(int** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchMatlabData(bool** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchMatlabData(bool** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
void FetchMatlabData(Matrix** pmatrix,const mxArray* dataref);
void FetchMatlabData(int** pvector,int* pM,const mxArray* dataref);
void FetchMatlabData(float** pvector,int* pM,const mxArray* dataref);
void FetchMatlabData(double** pvector,int* pM,const mxArray* dataref);
void FetchMatlabData(bool** pvector,int* pM,const mxArray* dataref);
void FetchMatlabData(Vector** pvector,const mxArray* dataref);
void FetchMatlabData(char** pstring,const mxArray* dataref);
void FetchMatlabData(char** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
void FetchMatlabData(double* pscalar,const mxArray* dataref);
void FetchMatlabData(int* pinteger,const mxArray* dataref);
void FetchMatlabData(bool* pbool,const mxArray* dataref);
void FetchMatlabData(Parameters** pparameters, DataHandle dataref);

Option* OptionParse(char* name, const mxArray* prhs[]);
OptionDouble*   OptionDoubleParse( char* name, const mxArray* prhs[]);
OptionLogical*  OptionLogicalParse( char* name, const mxArray* prhs[]);
OptionChar*     OptionCharParse( char* name, const mxArray* prhs[]);
OptionStruct*   OptionStructParse( char* name, const mxArray* prhs[]);
OptionCell*     OptionCellParse( char* name, const mxArray* prhs[]);
#endif
#endif	/* _IO_H_ */
