function femmodel=bedslope_core(femmodel)
%BEDSLOPE_CORE - core of the bed slope computation solution
%
%   Usage:
%      femmodel=bedslope_core(femmodel)
%

	%Recover some parameters:
	save_results=femmodel.parameters.SaveResults;

	issmprintf(VerboseSolution,'   computing bed slope');

	%Call on core computations: 
	femmodel=SetCurrentConfiguration(femmodel,BedSlopeAnalysisEnum,BedSlopeXAnalysisEnum);
	femmodel=solver_linear(femmodel);
	femmodel=SetCurrentConfiguration(femmodel,BedSlopeAnalysisEnum,BedSlopeYAnalysisEnum);
	femmodel=solver_linear(femmodel);
	
	if (save_results),
		issmprintf(VerboseSolution,'   saving results');
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedSlopeXEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedSlopeYEnum);
	end
