function femmodel=prognostic_core(femmodel)
%PROGNOSTIC_CORE - linear solution sequence
%
%   Usage:
%      femmodel=prognostic_core(femmodel)

	%recover parameters common to all solutions
	save_results=femmodel.parameters.SaveResults;

	%Activate formulation
	femmodel=SetCurrentConfiguration(femmodel,PrognosticAnalysisEnum);

	issmprintf(VerboseSolution,'\n%s',['   call computational core']);
	femmodel=solver_linear(femmodel);
	
	if (save_results),
		issmprintf(VerboseSolution,'\n%s',['   saving results']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum);
	end

end %end function
