function femmodel=enthalpy_core(femmodel)
%ENTHALPY_CORE - core of enthalpy solution
%
%   Usage:
%      femmodel=enthalpy_core(femmodel)

	%recover parameters common to all solutions
	save_results=femmodel.parameters.SaveResults;
	solution_type=femmodel.parameters.SolutionType;

	issmprintf(VerboseSolution,'\n%s',['   computing enthalpy']);
	femmodel=SetCurrentConfiguration(femmodel,EnthalpyAnalysisEnum);
	femmodel=solver_nonlinear(femmodel,true);

	if (save_results),
		issmprintf(VerboseSolution,'\n%s',['   saving results']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,EnthalpyEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,WaterfractionEnum);
	end

end %end of function
