/*\file OutputResults.c
 *\brief: output results inside elements, and in femmodel
 */

#include "./OutputResults.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes*   nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	Results* results=NULL;
	
	/* output datasets: */
	mxArray* dataref=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&OutputResultsUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTS);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&loads,LOADS);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);
	FetchMatlabData((DataSet**)&results,RESULTS);

	/*results might be NULL, allocate: */
	if(!results)results=new Results();

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*Call "x" code layer: */
	OutputResultsx(&dataref, elements,nodes,vertices,loads,materials,parameters,results);

	/*write output datasets: */
	plhs[0]=dataref;
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	delete results;

	/*end module: */
	MODULEEND();
}

void OutputResultsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [results] = %s(elements,nodes,vertices,loads,materials,parameters,results);\n",__FUNCT__);
	_printf_(true,"\n");
}
