/*\file InputToResult.c
 *\brief: duplicate input
 */

#include "./InputToResult.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int      enum_type,step; 
	double   time;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	//CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputToResultUsage); Cant' use it here, as we have variable inputs.
	if((nlhs!=NLHS) || (nrhs!=7 && nrhs!=9)){
		InputToResultUsage();
		_error_(" usage. See above");
	}

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTS);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&loads,LOADS);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);
	
	FetchMatlabData(&enum_type,ENUMTYPE);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*Call core code: */
	InputToResultx( elements, nodes, vertices, loads, materials,parameters,enum_type);

	/*write output : */
	WriteMatlabData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void InputToResultUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, enum_type,step,time);\n",__FUNCT__);
	_printf_(true,"   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, enum_type);\n",__FUNCT__);
	_printf_(true,"\n");
}
