function femmodel=adjointbalancethickness_core(femmodel),
%ADJOINT_CORE - compute inverse method adjoint state
%
%   Usage:
%      femmodel=adjointbalancethickness_core(femmodel)

	%recover parameters common to all solutions
	save_results=femmodel.parameters.SaveResults;
	solution_type=femmodel.parameters.SolutionType;

	%set analysis type to compute velocity:
	issmprintf(VerboseSolution,'   computing thickness');
	femmodel=SetCurrentConfiguration(femmodel,BalancethicknessAnalysisEnum);
	femmodel=solver_linear(femmodel);

	%Call SurfaceAreax, because some it might be needed by PVector
	femmodel.elements=SurfaceArea(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

	%compute adjoint
	issmprintf(VerboseSolution,'   computing adjoint');
	femmodel=SetCurrentConfiguration(femmodel,BalancethicknessAnalysisEnum,AdjointBalancethicknessAnalysisEnum);
	femmodel=solver_adjoint_linear(femmodel);

	%Save results
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointEnum);
	if(save_results),
		issmprintf(VerboseSolution,'   saving results');
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointEnum);
	end
