function femmodel=thermal_core(femmodel)
%THERMAL_CORE - core of thermal solution
%
%   Usage:
%      femmodel=thermal_core(femmodel)


	%recover parameters common to all solutions
	ndt=femmodel.parameters.TimesteppingFinalTime;
	dt=femmodel.parameters.TimesteppingTimeStep;
	control_analysis=femmodel.parameters.InversionIscontrol;
	solution_type=femmodel.parameters.SolutionType;

	issmprintf(VerboseSolution,'\n%s',['   computing temperature']);
	femmodel=thermal_core_step(femmodel); 

	if (solution_type==ThermalSolutionEnum & ~control_analysis),
		issmprintf(VerboseSolution,'\n%s',['   saving results']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BasalforcingsMeltingRateEnum);
	end

end %end of function
