%STEADYSTATE class definition
%
%   Usage:
%      steadystate=steadystate();

classdef steadystate
	properties (SetAccess=public) 
		reltol            = 0;
		maxiter           = 0;
		isdiagnostic      = 0;
		isthermal         = 0;
		requested_outputs = NaN;
	end
	methods
		function obj = steadystate(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
			%maximum of steady state iterations
			obj.maxiter=100;

			%Relative tolerance for the steadystate convertgence
			obj.reltol=0.01;
			 
			%Default is diagnostic and thermal
			obj.isdiagnostic=1;
			obj.isthermal=1;
		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if solution~=SteadystateSolutionEnum, return; end;

			if md.timestepping.time_step~=0,
				checkmessage(['model not consistent: for a steadystate computation, timestepping.time_step must be zero.']);
			end

			if isnan(md.diagnostic.reltol),
				checkmessage(['model not consistent: for a steadystate computation, diagnostic.reltol (relative convergence criterion) must be defined!']);
			end

			checkfield(md,'transient.isdiagnostic','numel',1,'values',[0 1]);
			checkfield(md,'transient.isthermal','numel',1,'values',[0 1]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   steadystate solution parameters:'));

			fielddisplay(obj,'reltol','relative tolerance criterion');
			fielddisplay(obj,'maxiter','maximum number of iterations');
			fielddisplay(obj,'isthermal','indicates if a thermal solution is used in the steady-state');
			fielddisplay(obj,'isdiagnostic','indicates if a diagnostic solution is used in the steady-state');
			fielddisplay(obj,'requested_outputs','additional requested outputs');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','reltol','format','Double');
			WriteData(fid,'object',obj,'fieldname','maxiter','format','Integer');
			WriteData(fid,'object',obj,'fieldname','isdiagnostic','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isthermal','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','requested_outputs','format','DoubleMat','mattype',3);
		end % }}}
	end
end
