function J =objectivefunction(search_scalar,femmodel);
%OBJECTIVEFUNCTION - objective function that return a parameter for a certain function
%
%   Usage:
%      J =objectivefunction(search_scalar,femmodel);

conserve_loads=true;
J=0;

%recover some parameters
analysis_type = femmodel.parameters.AnalysisType;
solution_type = femmodel.parameters.SolutionType;
isstokes      = femmodel.parameters.FlowequationIsstokes;

%set current configuration
if (solution_type==DiagnosticSolutionEnum | solution_type==SteadystateSolutionEnum)
	femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
elseif (solution_type==BalancethicknessSolutionEnum)
	femmodel=SetCurrentConfiguration(femmodel,BalancethicknessAnalysisEnum);
else
	error('solution not implemented yet');
end

%Use search scalar to shoot parameter in the gradient direction:
[femmodel.elements,femmodel.nodes,femmmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputControlUpdate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,search_scalar,0);

%Run diagnostic with updated inputs:
if (solution_type==DiagnosticSolutionEnum)
	femmodel=solver_nonlinear(femmodel,conserve_loads);  %true means we conserve loads at each diagnostic run
elseif (solution_type==SteadystateSolutionEnum)
	femmodel=diagnostic_core(femmodel);  %We need a 3D velocity!! (vz is required for the next thermal run)
elseif (solution_type==BalancethicknessSolutionEnum)
	femmodel=solver_linear(femmodel);
else
	error('solution not implemented yet');
end

%Compute misfit for this velocity field
J=CostFunction(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials, femmodel.parameters);
