%GEOMETRY class definition
%
%   Usage:
%      geometry=geometry();

classdef geometry
	properties (SetAccess=public) 
		surface           = NaN;
		thickness         = NaN;
		bed               = NaN;
		bathymetry        = NaN;
		hydrostatic_ratio = NaN;
	end
	methods
		function obj = geometry(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			checkfield(md,'geometry.surface'  ,'NaN',1,'size',[md.mesh.numberofvertices 1]);
			checkfield(md,'geometry.bed'      ,'NaN',1,'size',[md.mesh.numberofvertices 1]);
			checkfield(md,'geometry.thickness','NaN',1,'size',[md.mesh.numberofvertices 1],'>',0);
			if any((obj.thickness-obj.surface+obj.bed)>10^-9),
				checkmessage(['equality thickness=surface-bed violated']);
			end 
			if solution==TransientSolutionEnum & md.transient.isgroundingline,
				checkfield(md,'geometry.bathymetry','NaN',1,'size',[md.mesh.numberofvertices 1]);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   geometry parameters:'));

			fielddisplay(obj,'surface','surface elevation');
			fielddisplay(obj,'thickness','ice thickness');
			fielddisplay(obj,'bed','bed elevation');
			fielddisplay(obj,'bathymetry','bathymetry elevation');
			fielddisplay(obj,'hydrostatic_ratio','coefficient for ice shelves'' thickness correction: hydrostatic_ratio H_obs+ (1-hydrostatic_ratio) H_hydro');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'data',obj.surface,'format','DoubleMat','mattype',1,'enum',SurfaceEnum);
			WriteData(fid,'data',obj.thickness,'format','DoubleMat','mattype',1,'enum',ThicknessEnum);
			WriteData(fid,'data',obj.bed,'format','DoubleMat','mattype',1,'enum',BedEnum);
			WriteData(fid,'data',obj.bathymetry,'format','DoubleMat','mattype',1,'enum',BathymetryEnum);
			WriteData(fid,'object',obj,'fieldname','hydrostatic_ratio','format','DoubleMat','mattype',1);
		end % }}}
	end
end
