/*\file io.h
 *\brief: I/O for ISSM
 */

#ifndef IO_H_
#define IO_H_

#include "../objects/NodeSets.h"
#include "../DataSet/DataSet.h"

/*Define abstract type for I/O: */
#ifdef _SERIAL_
#include <mex.h>
typedef const mxArray* ConstDataHandle;  //serially, we are reading data from a matlab array.
typedef mxArray* DataHandle;  
#else 
typedef FILE* ConstDataHandle; //in parallel, we are reading data from a file.
typedef FILE* DataHandle; 
#endif


void FetchData(void** pdata,int* pM,int* pN,ConstDataHandle data_handle,char* data_type,char* sub_data_type);
void WriteData(DataHandle* pdata_handle,void* data,int M,int N,char* data_type,char* sub_data_type);
void ModelFetchData(void** pdata,int* pM,int* pN,ConstDataHandle model_handle,char* data_name,char* data_type,char* sub_data_type);

/*Serial: */
#ifdef _SERIAL_
void SerialFetchData(void** pdata,int* pM,int* pN,ConstDataHandle data_handle,char* data_type,char* sub_data_type);
void SerialWriteData(DataHandle* pdata_handle,void* data,int M,int N,char* data_type,char* sub_data_type);
void FetchNodeSets(NodeSets** pnodesets,ConstDataHandle dataref);
void WriteNodeSets(DataHandle* pdataref,NodeSets* nodesets);
void WriteParams(DataHandle* pdataref,DataSet* parameters);
#endif

/*Parallel: */
#ifdef _PARALLEL_
void ParallelFetchData(void** pdata,int* pM,int* pN,DataHandle data_handle, char* data_type,char* sub_data_type);
void ParallelFetchMat(double** pdata,int* pM,int* pN,DataHandle data_handle);
void ParallelFetchString(char** pdata,DataHandle data_handle);
void ParallelFetchScalar(double* pdata,DataHandle data_handle);
void ParallelFetchInteger(int* pdata,DataHandle data_handle);
void WriteDataToDisk(void* data,int* pM,int* pN,char* datatype,FILE* fid);
#endif

int FetchRifts(int** priftsnumpenaltypairs,double*** priftspenaltypairs,int** priftsfill,double** priftsfriction,ConstDataHandle model_handle,int numrifts);

#endif	/* _IMDB_H */

