#module imports
from fielddisplay import fielddisplay

class prognostic:
	#properties
	def __init__(self):
		# {{{ Properties
		self.spcthickness           = float('NaN')
		self.min_thickness          = 0
		self.hydrostatic_adjustment = 0
		self.stabilization          = 0
		self.vertex_pairing         = float('NaN')
		self.penalty_factor         = 0
		#}}}
	def __repr__(obj):
		# {{{ Display
		string='   Prognostic solution parameters:'
		string="%s\n\n%s"%(string,fielddisplay(obj,'spcthickness','thickness constraints (NaN means no constraint)'))
		string="%s\n%s"%(string,fielddisplay(obj,'min_thickness','minimum ice thickness allowed'))
		string="%s\n%s"%(string,fielddisplay(obj,'hydrostatic_adjustment','adjustment of ice shelves surface and bed elevations: ''Incremental'' or ''Absolute'' '))
		string="%s\n%s"%(string,fielddisplay(obj,'stabilization','0->no, 1->artificial_diffusivity, 2->streamline upwinding, 3->discontinuous Galerkin'))

		return string
		#}}}
