#!/usr/bin/env python
# STARTUP - Python startup script
#
#  startup.py is a script run by python at the beginning of a session, just
#  before handing over the prompt to the user if the environment variable
#  PYTHONSTARTUP is defined:
#  export PYTHONSTARTUP=$ISSM_TIER/startup.py
#  This startup script should be run by users before trying to use ISSM.

import os,sys

 
#First check we are running python 3 at least 
if sys.version_info[0] < 3:
	print("ISSM can only work in Python 3. Exiting python")
	sys.exit(1)

#Recover ISSM_TIER, ISSM_DIR  and USERNAME
ISSM_TIER=os.getenv('ISSM_TIER')
USERNAME =os.getenv('USER')
if(ISSM_TIER==None):
	raise NameError('"ISSM_TIER" environment variable is empty! You should define ISSM_TIER in your .cshrc or .bashrc!')

#Now add all issm code paths necessary to run issm smoothly. 
#We capture the error output, so that we can warn the user to update 
#the variable ISSM_TIER in this file, in case it is not correctly setup. 

#ISSM path. Go through src/py and load everything we find  that looks like a python file
for root,dirs,files in os.walk(ISSM_TIER+ '/src/py'):
	for file in files:
		if file.find(".py") != -1:
			if file.find(".pyc") == -1:
				#add to path 
				sys.path.append(root)
				file=os.path.splitext(file)[0]
				#__import__(file)

#Deal with scipy import: 
import scipy 
import numpy
import nose

#Import modules that are absolutely needed in ISSM {{{
from model import *
from mesh import *
from mask import *
from geometry import *
from constants import *
from surfaceforcings import *
from basalforcings import *
from materials import *
from friction import *
from flowequation import *
from fielddisplay import *
from timestepping import *
from initialization import *
from rifts import *
from debug import *
from settings import *
from solver import *
from issmtier  import * 
from ismumps  import * 
from pairoptions  import * 
from petscversion  import * 
from asmoptions import *           
from iluasmoptions import *        
from jacobiasmoptions import *     
from jacobicgoptions import *      
from matlaboptions import *        
from mumpsoptions import *         
from soroptions import *           
from stokesoptions import *
#}}}

print("\n  To get started with ISSM, type issmdoc at the command prompt.\n\n")
