
#ISSMTIER - Get ISSM_TIER environment variable contents.
#
#   Usage:
#      ISSM_TIER=issmtier()


#Module imports
import os

def issmtier():

	if os.name =="posix":
		ISSM_TIER =os.getenv('ISSM_TIER')
	else:
		ISSM_TIER =os.getenv('ISSM_TIER_WIN')

	if(ISSM_TIER[-1]=="/") or (ISSM_TIER[-1]=="\\"):
		ISSM_TIER = ISSM_TIER[:-2]; #shave off the last '/'

	if ISSM_TIER == "":
		raise RuntimeError("issmdir error message: ''ISSM_TIER'' environment variable is empty! You should define ISSM_TIER in your .cshrc or .bashrc!")
		
	return ISSM_TIER
