#module imports
from fielddisplay import fielddisplay

class materials:
	#properties
	def __init__(self):
		# {{{ Properties
		self.rho_ice                    = 0;
		self.rho_water                  = 0;
		self.mu_water                   = 0;
		self.heatcapacity               = 0;
		self.latentheat                 = 0;
		self.thermalconductivity        = 0;
		self.meltingpoint               = 0;
		self.beta                       = 0;
		self.mixed_layer_capacity       = 0;
		self.thermal_exchange_velocity  = 0;
		self.rheology_B   = float('NaN')
		self.rheology_n   = float('NaN')
		self.rheology_law = "";
		#}}}
	def __repr__(obj):
		# {{{ Display
		string="   Materials:"

		string="%s\n\n%s"%(string,fielddisplay(obj,"rho_ice","ice density [kg/m^3]"))
		string="%s\n%s"%(string,fielddisplay(obj,"rho_water","water density [kg/m^3]"))
		string="%s\n%s"%(string,fielddisplay(obj,"mu_water","water viscosity [N s/m^2]"))
		string="%s\n%s"%(string,fielddisplay(obj,"heatcapacity","heat capacity [J/kg/K]"))
		string="%s\n%s"%(string,fielddisplay(obj,"thermalconductivity","ice thermal conductivity [W/m/K]"))
		string="%s\n%s"%(string,fielddisplay(obj,"meltingpoint","melting point of ice at 1atm in K"))
		string="%s\n%s"%(string,fielddisplay(obj,"latentheat","latent heat of fusion [J/m^3]"))
		string="%s\n%s"%(string,fielddisplay(obj,"beta","rate of change of melting point with pressure [K/Pa]"))
		string="%s\n%s"%(string,fielddisplay(obj,"mixed_layer_capacity","mixed layer capacity [W/kg/K]"))
		string="%s\n%s"%(string,fielddisplay(obj,"thermal_exchange_velocity","thermal exchange velocity [m/s]"))
		string="%s\n%s"%(string,fielddisplay(obj,"rheology_B","flow law parameter [Pa/s^(1/n)]"))
		string="%s\n%s"%(string,fielddisplay(obj,"rheology_n","Glen""s flow law exponent"))
		string="%s\n%s"%(string,fielddisplay(obj,"rheology_law","law for the temperature dependance of the rheology: ""None"", ""Paterson"" or ""Arrhenius"""))

		return string
		#}}}
