function md=plugvelocities(md,filename,default_value)
%PLUGVELOCITIES - load velocities on a model
%
%   load a matlab file (extension .mat) which holds 4 variables
%   x,y,vx,vy to be plugged onto the model (or similar names)
%   x and y must be vectors, vx, vy matrices
%
%   Usage:
%      md=plugvelocities(md,filename,default_value)
%
%   Example:
%      md=plugvelocities(md,'velocityfile.mat',0);
%
%   See also: INTERPFROMFILE, GRIDDATA

%some checks
if nargin~=3 | nargout~=1
	help plugvelocities
	error('plugvelocities error message: bad usage');
end
if ~exist(filename)
	error(['plugvelocities error message: file ' filename  ' does not exist']);
end

%Get variables
A=whos('-file',filename);

%find x,y,vx and vy
xenum=NaN; yenum=NaN; vxenum=NaN; vyenum=NaN;
if length(A)==4,
	for i=1:4
		if strcmpi(A(i).name(1),'x');
			xenum=i;
		elseif strcmpi(A(i).name(1),'y');
			yenum=i;
		else
			if strcmpi(A(i).name(end),'x');
				vxenum=i;
			elseif strcmpi(A(i).name(end),'y');
				vyenum=i;
			end
		end
	end
else
	error(['plugvelocities error message: file ' filename  ' not supported yet (it should hold 4 variables x,y,vx and vy)']);
end

%assum that we have found at least vxenum and vyenum
if ( isnan(vxenum) | isnan(vyenum))
	error(['plugvelocities error message: file ' filename  ' not supported yet (it should hold 4 variables x,y,vx and vy)']);
end

%find x y
if (isnan(xenum) | isnan(yenum))

	%check the size
	if A(vxenum).size(1)==A(vxenum).size(2),
		error(['plugvelocities error message: file ' filename  ' not supported (velocities is a square matrix, save x and y with another name)']);
	end
	if ~(A(vxenum).size(1)==A(vyenum).size(1) & A(vxenum).size(2)==A(vyenum).size(2)),
		error(['plugvelocities error message: file ' filename  ' not supported (vx and vy matrices do not have the same size)']);
	end

	%find xenum and yenum
	for i=1:4
		lengthi=max(A(i).size);
		if ((i~=vxenum) & (lengthi==A(vxenum).size(1) | lengthi==A(vxenum).size(1)+1)),
			yenum=i;
		elseif ((i~=vxenum) & (lengthi==A(vxenum).size(2) | lengthi==A(vxenum).size(2)+1)),
			xenum=i;
		end
	end

	%last check
	if (isnan(xenum) | isnan(yenum))
		error(['plugdata error message: file ' filename  ' not supported yet']);
	end
end

%create names:
xname=A(xenum).name;
yname=A(yenum).name;
vxname=A(vxenum).name;
vyname=A(vyenum).name;

%load data
B=load(filename);

%get x y vx and vy
eval(['x=B.' xname ';'])
eval(['y=B.' yname ';'])
eval(['vx=B.' vxname ';'])
eval(['vy=B.' vyname ';'])

%interpolate
md.vx_obs=InterpFromGrid(x,y,vx,md.x,md.y,default_value);
md.vy_obs=InterpFromGrid(x,y,vy,md.x,md.y,default_value);
md.vx=md.vx_obs;
md.vy=md.vy_obs;
md.vel_obs=sqrt(md.vx_obs.^2+md.vy_obs.^2);
md.vel=md.vel_obs;
