# standard makefile to be use in each "component" subdir

.PHONY: FORCE

#get defaults from ~/.modelErc
HOMEDIR = $(wildcard ~)
MODELERC ?= $(HOMEDIR)/.modelErc
sinclude $(MODELERC)

#some of modelE definitions
#SCRIPTS_DIR = $(GISSCLIM_DIR)/scripts
#MOD_DIR = $(GISSCLIM_DIR)/mod
#LIB_DIR = $(GISSCLIM_DIR)/lib

#hack : make sure that ESMF_Interface is set
#ESMF_Interface = .

# the name for main target:
THIS := $(shell basename `pwd`)
LIB  = lib$(THIS).a

# directory for html documents
ifneq ($(THIS),model)
HTMLDOC_DIR_THIS = $(HTMLDOC_DIR)/COMPONENT___$(THIS)
else
HTMLDOC_DIR_THIS = $(HTMLDOC_DIR)
endif

#hack
DEPENDFILE = .depend

#hack to build archive on MAC
RANLIB_FLAGS = 
ifeq ($(shell uname),Darwin)
RANLIB_FLAGS = -c
endif

#default target:
default: $(LIB)

#hack to overwrite the list of sources from rundeck
ifdef OVERWRITE_FSRCS
FSRCS = $(OVERWRITE_FSRCS)
endif
ifdef OVERWRITE_F90SRCS
F90SRCS = $(OVERWRITE_F90SRCS)
endif

OBJS = $(FSRCS:.f=.o) $(CSRCS:.c=.o) $(F90SRCS:.F90=.o)
FSRCS_CPP = $(FSRCS:.f=.f.cpp)
F90SRCS_CPP = $(F90SRCS:.F90=.F90.cpp)

FFSRCS = $(FSRCS) $(F90SRCS)
FFSRCS_CPP = $(FSRCS_CPP) $(F90SRCS_CPP)

#rule for "ar" , should be moved to rules later
$(LIB): $(OBJS)
	-rm -f $(LIB)
	ar rcs $(LIB) $(OBJS)
	$(RANLIB) $(RANLIB_FLAGS) $(LIB)
	-cp -p $(MODS) $(MOD_DIR)
#	cp $(LIB) $(LIB_DIR)

#rundeck_opts.h: $(DECKS_DIR)/$(RUN).mk
#	perl -e '$$_="$(CPP_OPTIONS)"; s/ *\#/\n\#/g; print "$$_\n";' \
#	 > rundeck_opts.h.tmp
#	if ! cmp -s rundeck_opts.h.tmp rundeck_opts.h ; then \
#	  mv rundeck_opts.h.tmp rundeck_opts.h ; \
#	else \
#	  rm rundeck_opts.h.tmp ; \
#	fi

$(DEPENDFILE): $(FFSRCS) .current_options $(RUN_H)   # $(RUNDECK) $(FSRCS) $(RUN_H)
	@echo
	@echo '--------          Rebuilding Dependencies  in        ---------'
	@echo '--' `pwd`
#	[ -f $(RUN_H) ] || touch $(RUN_H)
	echo "# dependencies generated by cpp:" > $(DEPENDFILE)
	@echo '====> running CPP'
ifeq ($(MACHINE),IBM)
	for i in $(FFSRCS); do $(CPP) -M $(CPPFLAGS) $$i > $$i.cpp; \
	cat $${i%.f}.u >> $(DEPENDFILE); done
else
ifeq ($(MACHINE),Linux)
# hack to get around use of 'traditional' in cpp call
	for i in $(FFSRCS); do $(CPP) -M $(CPPFLAGS) $$i | sed 's/\.f\.o/.o/g' >> $(DEPENDFILE); \
	$(CPP) $(CPPFLAGS) $$i > $$i.cpp; done
else
	for i in $(FFSRCS); do $(CPP) -M $(CPPFLAGS) $$i >> $(DEPENDFILE); \
	$(CPP) $(CPPFLAGS) $$i > $$i.cpp; done
endif
endif
	@echo '====> running fmakedep'
#       $(FMAKEDEP) $(INCS) -f $(DEPENDFILE)_tmp $(FFSRCS_CPP) 
	$(FMAKEDEP) -f $(DEPENDFILE)_tmp $(FFSRCS_CPP) 
	$(SCRIPTS_DIR)/pproc_dep.pl  $(DEPENDFILE)_tmp > $(DEPENDFILE)_tmp1
	cat $(DEPENDFILE)_tmp1 >> $(DEPENDFILE)
	rm -f $(FFSRCS_CPP) $(DEPENDFILE)_tmp $(DEPENDFILE)_tmp1
	@echo '---------         done with dependencies             ---------'
	@echo

clean:
	-rm -f $(LIB) lib.a *.o *.mod *.smod .depend* .current_options rundeck_opts.h

deplist:
	echo $(THIS)_dir: $(DEPENDS_ON:=_dir)
	-rm $(DEPENDFILE)

MODS = $(shell [ -s $(DEPENDFILE) ] && perl \
        -e 'while(<>){ push @a, /(\S+\.mod)\s*:/gi; } print join " ",@a;' \
        $(DEPENDFILE) )

depend: $(DEPENDFILE)

.current_options: FORCE
	@echo $(CURRENT_OPTIONS) > .current_options.tmp
	@if [ ! -f .current_options ] || \
	! cmp -s .current_options  .current_options.tmp ; then \
	mv -f .current_options.tmp .current_options; \
	else rm -f .current_options.tmp ; \
	fi

# create a list of all specified options, including the list
# of source files
define PROGRAM_opt_list
CURRENT_OPTIONS += $(1)=$($(1)),
endef

CURRENT_OPTIONS =
$(foreach v,$(SUPPORTED_OPTIONS) FFSRCS, \
  $(eval $(call PROGRAM_opt_list,$(v))))

ifneq ($(MAKECMDGOALS),clean)
sinclude $(DEPENDFILE)
endif


# html documantation
htmldoc: $(FSRCS_CPP)
	[ -d $(HTMLDOC_DIR) ] || mkdir $(HTMLDOC_DIR)
	-mkdir $(HTMLDOC_DIR_THIS)
	$(SCRIPTS_DIR)/gcmdoc.pl -O $(HTMLDOC_DIR_THIS) -R $(RUN) -C $(THIS) -CPP f.cpp $(FSRCS)
	rm -f $(FSRCS_CPP)

