function md=solveparallel(md,options)
%SOLVEPARALLEL - solution sequence using a cluster in parallel mode
%
%   Usage:
%      md=solveparallel(md);

%retrieve cluster: otherwise, we can't call its methods (subsref bug)
cluster=md.cluster;

if options.loadonly,  
	md=loadresultsfromcluster(md);
else

	%In parallel mode, we need to make sure we have PETSC support, otherwise, we run with only one cpu: 
	if ~ispetsc,
		disp('PETSC support not included, running on 1 cpu only!');
		cluster.np=1;
	end

	%First, build a runtime name that is unique, that we will use to create 
	%directories, name jobs, etc ...
	c=clock; md.private.runtimename=sprintf('%s-%02i-%02i-%04i-%02i-%02i-%02i-%i',md.miscellaneous.name,c(2),c(3),c(1),c(4),c(5),floor(c(6)),feature('GetPid'));

	if verLessThan('matlab', '7.6')
		BuildQueueScript(cluster,md);
		LaunchQueueJob(cluster,md,options);
	else
		cluster.BuildQueueScript(md);
		cluster.LaunchQueueJob(md,options);
	end

	if ~strcmpi(options.upload,'on'), %did we even try to run? if so, wait on lock

		%Do we return, or just wait for results?
		if (md.settings.waitonlock>0 &  ~strcmpi(options.batch,'yes')),
			%we wait for the done file
			islock=waitonlock(md);
			if islock==0,
				%no results to be loaded
				disp('The results must be loaded manually with md=loadresultsfromcluster(md).');
			else
				%load results
				disp('loading results from cluster');
				md=loadresultsfromcluster(md);
			end
		end

		%post processes qmu results if necessary
		if md.qmu.isdakota,
			if ~strncmpi(options.keep,'y',1)
				system(['rm -rf qmu' num2str(feature('GetPid'))]);
			end
		end
	else
		error('solveparallel done uploading test decks');
	end

end
