/*!\file MPI_Upperrow.cpp
 * \brief: routine to distribute jobs in parallel. 
 * This handy routine will provide, along with the MPI_Lowrrow, a distributed range 
 * for an index (like i,j, in a for loop). 
 * Ex: for(i=MPI_Lowerrow(num_procs)0;i<MPI_Upperrow(num_procs);i++)
 * This ensures easy parallelisation of loops if needed.
 */

#include "./mpipatches.h"

int MPI_Upperrow(int n){

	int range;
	int lower_row;
	int upper_row;

	/*First, figure out our range : */
	range=DetermineLocalSize(n);

	/*Now determien upper and lower boundaries: */
	MPI_Boundariesfromrange(&lower_row,&upper_row,range);

	return upper_row;
	
}





