#!/bin/sh

#petsc 3.2
#mpich 1.4

./configure \
	--prefix=$ISSM_TIER \
	--with-matlab-dir=$MATLAB_DIR \
	--with-triangle-dir=$ISSM_TIER/externalpackages/triangle/install \
	--with-metis-dir=$ISSM_TIER/externalpackages/metis/install \
	--with-mpi-include=$ISSM_TIER/externalpackages/mpich2/install/include  \
	--with-mpi-lib=" $ISSM_TIER/externalpackages/mpich2/install/lib/libpmpich.a $ISSM_TIER/externalpackages/mpich2/install/lib/libmpich.a $ISSM_TIER/externalpackages/mpich2/install/lib/libmpl.a " \
	--with-chaco-dir=$ISSM_TIER/externalpackages/chaco/install \
	--with-fortran-lib="/usr/local/lib/libgfortran.a" \
	--with-dakota-dir=$ISSM_TIER/externalpackages/dakota/install \
	--with-math-lib="/usr/lib/libm.dylib" \
	--with-graphics-lib="/usr/X11/lib/libX11.dylib" \
	--with-cxxoptflags=" -fno-common -no-cpp-precomp -fexceptions -arch x86_64 -mmacosx-version-min=10.5  -O3 -DNDEBUG -w "\
	--with-numthreads=8 \
	--with-petsc-dir=$ISSM_TIER/externalpackages/petsc/install  \
	--with-petsc-arch=$ISSM_ARCH \
	--with-blas-lapack-dir=$ISSM_TIER/externalpackages/petsc/install \
	--with-plapack-lib="-L$ISSM_TIER/externalpackages/petsc/install/ -lPLAPACK" \
	--with-plapack-include="-I$ISSM_TIER/externalpackages/petsc/install/include/ " \
	--with-blacs-dir=$ISSM_TIER/externalpackages/petsc/install/ \
	--with-scalapack-dir=$ISSM_TIER/externalpackages/petsc/install/ \
	--with-mumps-dir=$ISSM_TIER/externalpackages/petsc/install/ 
