/*! \file PentaP1ElementResult.h 
 *  \brief: header file for PentaP1ElementResult object
 *  this object is just a PentaP1Input with additional time and step info.
 */


#ifndef _PENTAP1ELEMENTRESULT_H_
#define _PENTAP1ELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class PentaP1ElementResult: public ElementResult{

	private: 
		int    enum_type;
		double values[6];
		int    step;
		double time;

	public:

		/*PentaP1ElementResult constructors, destructors: {{{1*/
		PentaP1ElementResult();
		PentaP1ElementResult(int enum_type,double* values,int step, double time);
		~PentaP1ElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{1*/
		ElementResult* SpawnTriaElementResult(int* indices);
		double  GetTime(void){return time;};
		int     GetStep(void){return step;};
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*PentaP1ElementResult management: {{{1*/
		int   InstanceEnum();
		void GetVectorFromResults(Vector* vector,int* doflist,int* connectivitylist,int numdofs);
		void GetElementVectorFromResults(Vector* vector,int dof);
		/*}}}*/

};
#endif  /* _PENTAP1ELEMENTRESULT_H */
