/*!\file PentaP1ElementResult.c
 * \brief: implementation of the PentaP1ElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "./ElementResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*PentaP1ElementResult constructors and destructor*/
/*FUNCTION PentaP1ElementResult::PentaP1ElementResult(){{{1*/
PentaP1ElementResult::PentaP1ElementResult(){
	return;
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::PentaP1ElementResult(int in_enum_type,double* in_values,int in_step, double in_time){{{1*/
PentaP1ElementResult::PentaP1ElementResult(int in_enum_type,double* in_values,int in_step, double in_time){

	int i;

	enum_type=in_enum_type;
	for(i=0;i<6;i++)values[i]=in_values[i];
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::~PentaP1ElementResult(){{{1*/
PentaP1ElementResult::~PentaP1ElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION PentaP1ElementResult::Echo {{{1*/
void PentaP1ElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::DeepEcho{{{1*/
void PentaP1ElementResult::DeepEcho(void){

	printf("PentaP1ElementResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   values: [%g %g %g %g %g %g]\n",this->values[0],this->values[1],this->values[2],this->values[3],this->values[4],this->values[5]);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::Id{{{1*/
int    PentaP1ElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION PentaP1ElementResult::MyRank{{{1*/
int    PentaP1ElementResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION PentaP1ElementResult::Marshall{{{1*/
void  PentaP1ElementResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of PentaP1ElementResult: */
	enum_value=PentaP1ElementResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall PentaP1ElementResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::MarshallSize{{{1*/
int   PentaP1ElementResult::MarshallSize(){
	
	return sizeof(values)+
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::Demarshall{{{1*/
void  PentaP1ElementResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION PentaP1ElementResult::ObjectEnum{{{1*/
int PentaP1ElementResult::ObjectEnum(void){

	return PentaP1ElementResultEnum;

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::copy{{{1*/
Object* PentaP1ElementResult::copy() {
	
	return new PentaP1ElementResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION PentaP1ElementResult::InstanceEnum{{{1*/
int PentaP1ElementResult::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::SpawnTriaElementResult{{{1*/
ElementResult* PentaP1ElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	TriaP1ElementResult* outresult=NULL;
	double newvalues[3];

	/*Loop over the new indices*/
	for(int i=0;i<3;i++){

		/*Check index value*/
		_assert_(indices[i]>=0 && indices[i]<6);

		/*Assign value to new result*/
		newvalues[i]=this->values[indices[i]];
	}

	/*Create new Tria result*/
	outresult=new TriaP1ElementResult(this->enum_type,&newvalues[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::ProcessUnits{{{1*/
void PentaP1ElementResult::ProcessUnits(Parameters* parameters){
	
	UnitConversion(this->values,6,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::NumberOfNodalValues{{{1*/
int PentaP1ElementResult::NumberOfNodalValues(void){
	return 6;
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::PatchFill{{{1*/
void PentaP1ElementResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,6);

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::GetVectorFromResults{{{1*/
void PentaP1ElementResult::GetVectorFromResults(Vector* vector,int* doflist,int* connectivitylist,int numdofs){

	double data[6];

	if(numdofs!=6)_error_("Result %s is a PentaP1ElementResult and cannot write vector of %i dofs",numdofs);
	for(int i=0;i<6;i++) data[i]=this->values[i]/(double)connectivitylist[i];
	vector->SetValues(numdofs,doflist,&data[0],ADD_VAL);

} /*}}}*/
/*FUNCTION PentaP1ElementResult::GetElementVectorFromResults{{{1*/
void PentaP1ElementResult::GetElementVectorFromResults(Vector* vector,int dof){

	_error_("Result %s is a PentaP1ElementResult and should not write vector of size numberofelemenrs",EnumToStringx(enum_type));
} /*}}}*/
