/*\file Orth.c
 *\brief: orthogonalize searching directions for inverse control methods.
 */

#include "./Orth.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vector* gradj=NULL;
	Vector* oldgradj=NULL;

	/* output datasets: */
	Vector* newgradj=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&OrthUsage);

	/*Input datasets: */
	FetchMatlabData(&gradj,GRADJ);
	FetchMatlabData(&oldgradj,OLDGRADJ);

	/*!Reduce load from g to f size: */
	Orthx(&newgradj, gradj,oldgradj);

	/*write output datasets: */
	WriteMatlabData(NEWGRADJ,newgradj);

	/*Free ressources: */
	xdelete(&gradj);
	xdelete(&oldgradj);
	xdelete(&newgradj);

	/*end module: */
	MODULEEND();
}

void OrthUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [newgradj] = %s(gradj,oldgradj);\n",__FUNCT__);
	_printf_(true,"\n");
}
