/*\file Solver.c
 *\brief: solver
 */

#include "./Solver.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Matrix*         Kff           = NULL;
	Vector*         pf            = NULL;
	Vector*         uf0           = NULL;
	Vector*         uf            = NULL;
	Vector*         df            = NULL;
	Parameters *parameters    = NULL;
	int         analysis_type;
	char*       options=NULL;
	char*       token=NULL;
	char*       option=NULL;

	/*For use of matlab solver: */
	mxArray* array[2];

	/*Start module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SolverUsage);
	
	/*parameters: */
	FetchMatlabData(&parameters,PARAMETERS);

	/*In serial mode, we have not set any petsc options, do it now: */
	
	options=OptionsFromAnalysis(parameters,analysis_type);
	token=strstr(options,"--ksp_type");

	/*Fetch rest of data only if not running the matlab solver: */
	if ((token==NULL) || (strncmp(token+10,"matlab",6)!=0)){
	
		/*Input datasets: */
		FetchMatlabData(&Kff,KFF);
		FetchMatlabData(&pf,PF);
		FetchMatlabData(&uf0,UF0);
		FetchMatlabData(&df,DF);

		/*Core module: */
		Solverx(&uf, Kff, pf, uf0, df,parameters);

		/*Write output*/
		WriteMatlabData(UF,uf);
	}
	else{
		/*Call Matlab solver: */
		if (VerboseModule()) printf("   Solving\n");
		array[0]=KFF;
		array[1]=PF;
		mexCallMATLAB(1,UF,2,array,"mldivide");
	}

	/*Free ressources: */
	xdelete(&Kff);
	xdelete(&pf);
	xdelete(&uf0);
	xdelete(&uf);
	xdelete(&df);
	delete parameters;

	MODULEEND();

}

void SolverUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [uf] = %s(Kff,pf,uf0,df,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
