/*! \file Vertex.h 
 *  \brief: header file for vertex object
 */

#ifndef _VERTEX_H_
#define _VERTEX_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
class IoModel;
class Vector;
class Parameters;
#include "../shared/Exceptions/exceptions.h"
#include "../toolkits/toolkits.h"
#include "../include/include.h"

/*}}}*/


class Vertex: public Object{

	public: 

		int    id;
		int    sid;            //sid for "serial" id, ie the rank of this vertex in the vertices dataset, if the dataset was serial on 1 cpu.
		double x;
		double y;
		double z;
		double sigma;          //sigma coordinate: (z-bed)/thickness
		int    connectivity;   //number of vertices connected to this vertex

		/*dof management: */
		int    clone;
		int    dof; //dof to recover values in a vertex indexed vector

		/*Vertex constructors, destructors {{{1*/
		Vertex();
		Vertex(int id, int sid,double x, double y, double z, double sigma, int connectivity); 
		void Init(int id, int sid, double x, double y, double z, double sigma,int connectivity);
		Vertex(int id, int sid, int i, IoModel* iomodel);
		~Vertex();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*DofObject routines {{{1*/
		void  DistributeDofs(int* pdofcount);
		void  OffsetDofs(int dofcount);
		void  ShowTrueDofs(int* borderdofs);
		void  UpdateCloneDofs(int* allborderdofs);
		void  SetClone(int* minranks);
		/*}}}*/
		/*Vertex management: {{{1*/
		int   Sid(void); 
		int   Connectivity(void); 
		void  UpdatePosition(Vector* vz,Parameters* parameters,double* thickness,double* bed);
		/*}}}*/
};
#endif  /* _VERTEX_H */
