/*! \file BoolInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLINPUT_H_
#define _BOOLINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../../include/include.h"
class GaussTria;
/*}}}*/

class BoolInput: public Input{

	public:
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmBool value;

		/*BoolInput constructors, destructors: {{{1*/
		BoolInput();
		BoolInput(int enum_type,IssmBool value);
		~BoolInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*BoolInput management: {{{1*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, double time);
		void Configure(Parameters* parameters);
		void AddTimeValues(double* values,int step,double time){_error_("not supported yet");};
		/*}}}*/
		/*numerics: {{{1*/
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(double* pvalue);
		void GetInputValue(double* pvalue,GaussTria* gauss);
		void GetInputValue(double* pvalue,GaussPenta* gauss);
		void GetInputValue(double* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss);
		void GetInputAverage(double* pvalue){_error_("not implemented yet");};
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(double minimum){_error_("not implemented yet");};
		double InfinityNorm(void){_error_("InfinityNorm not implemented for booleans");};
		double Max(void){_error_("Max not implemented for booleans");};
		double MaxAbs(void){_error_("Max not implemented for booleans");};
		double Min(void){_error_("Min not implemented for booleans");};
		double MinAbs(void){_error_("Min not implemented for booleans");};
		void Scale(double scale_factor);
		void ArtificialNoise(double min,double max){_error_("not implemented yet");};
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input){_error_("not supported yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _BOOLINPUT_H */
