/*! \file TriaP1ElementResult.h 
 *  \brief: header file for TriaP1ElementResult object
 */


#ifndef _TRIAP1ELEMENTRESULT_H_
#define _TRIAP1ELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class TriaP1ElementResult: public ElementResult{

	private: 
		int    enum_type;
		double values[3];
		int    step;
		double time;

	public:

		/*TriaP1ElementResult constructors, destructors: {{{1*/
		TriaP1ElementResult();
		TriaP1ElementResult(int enum_type,double* values,int step,double time);
		~TriaP1ElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{1*/
		ElementResult* SpawnTriaElementResult(int* indices);
		double  GetTime(void){return time;};
		int     GetStep(void){return step;};
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*TriaP1ElementResult management: {{{1*/
		int   InstanceEnum();
		void GetVectorFromResults(Vector* vector,int* doflist,int* connectivitylist,int numdofs);
		void GetElementVectorFromResults(Vector* vector,int dof);
		/*}}}*/

};
#endif  /* _TRIAP1ELEMENTRESULT_H */
