/*!\file TriaP1ElementResult.c
 * \brief: implementation of the TriaP1ElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "./ElementResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*TriaP1ElementResult constructors and destructor*/
/*FUNCTION TriaP1ElementResult::TriaP1ElementResult(){{{1*/
TriaP1ElementResult::TriaP1ElementResult(){
	return;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::TriaP1ElementResult(int in_enum_type,double* in_values,int in_step, double in_time){{{1*/
TriaP1ElementResult::TriaP1ElementResult(int in_enum_type,double* in_values,int in_step, double in_time){

	enum_type=in_enum_type;
	values[0]=in_values[0];
	values[1]=in_values[1];
	values[2]=in_values[2];
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::~TriaP1ElementResult(){{{1*/
TriaP1ElementResult::~TriaP1ElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION TriaP1ElementResult::Echo {{{1*/
void TriaP1ElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::DeepEcho{{{1*/
void TriaP1ElementResult::DeepEcho(void){
		
	printf("TriaP1ElementResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   values: [%g %g %g]\n",this->values[0],this->values[1],this->values[2]);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::Id{{{1*/
int    TriaP1ElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION TriaP1ElementResult::MyRank{{{1*/
int    TriaP1ElementResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION TriaP1ElementResult::Marshall{{{1*/
void  TriaP1ElementResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;


	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of TriaP1ElementResult: */
	enum_value=TriaP1ElementResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall TriaP1ElementResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::MarshallSize{{{1*/
int   TriaP1ElementResult::MarshallSize(){
	
	return sizeof(values)
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::Demarshall{{{1*/
void  TriaP1ElementResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION TriaP1ElementResult::ObjectEnum{{{1*/
int TriaP1ElementResult::ObjectEnum(void){

	return TriaP1ElementResultEnum;

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::copy{{{1*/
Object* TriaP1ElementResult::copy() {
	
	return new TriaP1ElementResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION TriaP1ElementResult::InstanceEnum{{{1*/
int TriaP1ElementResult::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::SpawnTriaElementResult{{{1*/
ElementResult* TriaP1ElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	TriaP1ElementResult* outresult=NULL;

	/*Create new Tria result (copy of current result)*/
	outresult=new TriaP1ElementResult(this->enum_type,&this->values[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::ProcessUnits{{{1*/
void TriaP1ElementResult::ProcessUnits(Parameters* parameters){
	
	UnitConversion(this->values,3,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::NumberOfNodalValues{{{1*/
int TriaP1ElementResult::NumberOfNodalValues(void){
	return 3;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::PatchFill{{{1*/
void TriaP1ElementResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,3);

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::GetVectorFromResults{{{1*/
void TriaP1ElementResult::GetVectorFromResults(Vector* vector,int* doflist,int* connectivitylist,int numdofs){

	double data[3];

	if(numdofs!=3)_error_("Result %s is a TriaP1ElementResult and cannot write vector of %i dofs",numdofs);
	for(int i=0;i<3;i++) data[i]=this->values[i]/(double)connectivitylist[i];
	vector->SetValues(numdofs,doflist,&data[0],ADD_VAL);

} /*}}}*/
/*FUNCTION TriaP1ElementResult::GetElementVectorFromResults{{{1*/
void TriaP1ElementResult::GetElementVectorFromResults(Vector* vector,int dof){
	_error_("Result %s is a TriaP1ElementResult and should not write vector of size numberofelemenrs",EnumToStringx(enum_type));
} /*}}}*/
