/*!\file Solverx
 * \brief solver
 */

#include "./Solverx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../io/io.h"

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

void	Solverx(Vector** puf, Matrix* Kff, Vector* pf, Vector* uf0,Vector* df, Parameters* parameters){

	/*output: */
	Vector* uf=NULL;
	uf=new Vector();

	#ifdef _HAVE_PETSC_
	Vec uf0_vector = NULL;
	Vec df_vector  = NULL;
	if(uf0) uf0_vector=uf0->vector;
	if(df)  df_vector = df->vector;

	SolverxPetsc(&uf->vector,Kff->matrix,pf->vector,uf0_vector,df_vector,parameters);
	VecGetSize(uf->vector,&uf->M);
	#else
	_error_("not supported yet!");
	#endif

	/*Assign output pointers: */
	*puf=uf;
}
