/*\file InputUpdateFromSolution.c
*\brief: update elements properties using a solution vector
*/

#include "./InputUpdateFromSolution.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	Vector*      solution=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputUpdateFromSolutionUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTSIN);
	FetchMatlabData((DataSet**)&nodes,NODESIN);
	FetchMatlabData((DataSet**)&vertices,VERTICESIN);
	FetchMatlabData((DataSet**)&loads,LOADSIN);
	FetchMatlabData((DataSet**)&materials,MATERIALSIN);
	FetchMatlabData(&parameters,PARAMETERSIN);
	FetchMatlabData(&solution,SOLUTION);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Generate internal degree of freedom numbers: */
	InputUpdateFromSolutionx(elements,nodes,vertices,loads, materials,parameters,solution);

	/*write output datasets: */
	WriteMatlabData(ELEMENTS,elements);
	WriteMatlabData(MATERIALS,materials);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	delete solution;

	/*end module: */
	MODULEEND();
}

void InputUpdateFromSolutionUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements,materials] = %s(elements,nodes,vertices,loads,materials,parameters,solution);\n",__FUNCT__);
	_printf_(true,"\n");
}
