%FRICTION class definition
%
%   Usage:
%      friction=friction();

classdef friction
	properties (SetAccess=public) 
		coefficient = NaN;
		p           = NaN;
		q           = NaN;
	end
	methods
		function obj = friction(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if ~ismember(DiagnosticHorizAnalysisEnum,analyses) & ~ismember(ThermalAnalysisEnum,analyses), return; end

			checkfield(md,'friction.coefficient','NaN',1,'size',[md.mesh.numberofvertices 1]);
			checkfield(md,'friction.q','NaN',1,'size',[md.mesh.numberofelements 1]);
			checkfield(md,'friction.p','NaN',1,'size',[md.mesh.numberofelements 1]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p'));
			fielddisplay(obj,'coefficient','friction coefficient [SI]');
			fielddisplay(obj,'p','p exponent');
			fielddisplay(obj,'q','q exponent');
		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','coefficient','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','p','format','DoubleMat','mattype',2);
			WriteData(fid,'object',obj,'fieldname','q','format','DoubleMat','mattype',2);
		end % }}}
	end
end
