/* \file MatlabMatrixToMatrix.cpp
 * \brief: convert a sparse or dense matlab matrix to a matrix:
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#ifdef _SERIAL_

/*Matlab includes: */
#include "mex.h"
#include "../../objects/objects.h"

Matrix* MatlabMatrixToMatrix(const mxArray* mxmatrix){

	Matrix* matrix=NULL;

	#ifdef _HAVE_PETSC_
	/*allocate matrix object: */
	matrix=new Matrix();
	
	/*Call Matlab to Petsc API: */
	MatlabMatrixToPetscMatrix(&matrix->matrix,&matrix->M,&matrix->N,mxmatrix);

	#else
		_error_("not supported yet!");
	#endif

	return matrix;
}
#endif
