/*!\file Reducevectorgtosx
 * \brief reduce petsc vector from g set to s set (single point constraints), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtosx.h"

void Reducevectorgtosx(Vector** pys, Vector* yg, Nodes* nodes,Parameters* parameters){

	/*output: */
	Vector* ys=NULL;

	/*variables: */
	int i;
	int configuration_type;
	int ssize;
	double* yg_serial=NULL;

	/*first figure out ssize: */
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	ssize=nodes->NumberOfDofs(configuration_type,SsetEnum);

	if(ssize==0){
		ys=NULL;
	}
	else{
		/*allocate: */
		ys=new Vector(ssize);

		if(nodes->NumberOfNodes(configuration_type)){ 

			/*serialize yg, so nodes can index into it: */
			yg_serial=yg->ToMPISerial();

			/*Go throygh all nodes, and ask them to retrieve values from yg, and plyg them into ys: */
			for(i=0;i<nodes->Size();i++){

				Node* node=(Node*)nodes->GetObjectByOffset(i);

				/*Check that this node corresponds to our analysis currently being carried out: */
				if (node->InAnalysis(configuration_type)){

					/*For this object, reduce values for enum set Fset: */
					node->VecReduce(ys,yg_serial,SsetEnum);
				}
			}
		}
		/*Assemble vector: */
		ys->Assemble();
	}

	/*Free ressources:*/
	xfree((void**)&yg_serial);

	/*Assign output pointers:*/
	*pys=ys;
}
