/*\file CreateNodalConstraints.c
 *\brief: reduce g set vector to s set vector (set of single point constraints)
 */

#include "./CreateNodalConstraints.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Nodes *nodes         = NULL;
	int    analysis_type;

	/* output datasets: */
	Vector* ys=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&CreateNodalConstraintsUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData(&analysis_type,ANALYSISTYPE);

	/*!Reduce vector: */
	CreateNodalConstraintsx(&ys,nodes,analysis_type);

	/*write output datasets: */
	WriteMatlabData(YS,ys);

	/*Free ressources: */
	delete nodes;
	delete ys;

	/*end module: */
	MODULEEND();
}

void CreateNodalConstraintsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: ys = %s(nodes,analysis_type);\n",__FUNCT__);
	_printf_(true,"\n");
}
