function [analyses,numanalyses]=AnalysisConfiguration(solutiontype),
%ANALYSISCONFIGURATION - return type of analyses, number of analyses 
%
%   Usage:
%      [analyses, numanalyses]=AnalysisConfiguration(solutiontype);



switch solutiontype,

	case DiagnosticSolutionEnum,
		numanalyses=5;
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum];

	case SteadystateSolutionEnum,
		numanalyses=8; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;EnthalpyAnalysisEnum;ThermalAnalysisEnum;MeltingAnalysisEnum];

	case ThermalSolutionEnum,
		numanalyses=2; 
		analyses=[ThermalAnalysisEnum;MeltingAnalysisEnum];

	case EnthalpySolutionEnum,
		numanalyses=1; 
		analyses=[EnthalpyAnalysisEnum];

	case PrognosticSolutionEnum,
		numanalyses=1; 
		analyses=[PrognosticAnalysisEnum];

	case BalancethicknessSolutionEnum,
		numanalyses=1; 
		analyses=[BalancethicknessAnalysisEnum];

	case SurfaceSlopeSolutionEnum,
		numanalyses=1; 
		analyses=[SurfaceSlopeAnalysisEnum];

	case BedSlopeSolutionEnum,
		numanalyses=1; 
		analyses=[BedSlopeAnalysisEnum];

	case TransientSolutionEnum,
		numanalyses=9; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;ThermalAnalysisEnum;MeltingAnalysisEnum;EnthalpyAnalysisEnum;PrognosticAnalysisEnum];

	case FlaimSolutionEnum,
		numanalyses=1; 
		analyses=[FlaimAnalysisEnum];

	case HydrologySolutionEnum,
		numanalyses=3; 
		analyses=[BedSlopeAnalysisEnum;SurfaceSlopeAnalysisEnum;HydrologyAnalysisEnum];

	otherwise
		error('%s%s%s',' solution type: ',EnumToString(solutiontype),' not supported yet!');

end
