/* \file MatlabVectorToVector.cpp
 * \brief: convert a sparse or dense matlab vector to a vector:
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#ifdef _SERIAL_

/*Matlab includes: */
#include "mex.h"
#include "../../objects/objects.h"

Vector* MatlabVectorToVector(const mxArray* mxvector){

	Vector* vector=NULL;

	#ifdef _HAVE_PETSC_
	/*allocate vector object: */
	vector=new Vector();
	
	/*Call Matlab to Petsc API: */
	MatlabVectorToPetscVector(&vector->vector,&vector->M,mxvector);

	#else
		_error_("not supported yet!");
	#endif

	return vector;
}
#endif
