/*!\file: solver_linear.cpp
 * \brief: numerical core of linear solutions
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"

void solver_linear(FemModel* femmodel){

	/*intermediary: */
	Matrix*  Kff = NULL;
	Matrix*  Kfs = NULL;
	Vector*  ug  = NULL;
	Vector*  uf  = NULL;
	Vector*  pf  = NULL;
	Vector*  df  = NULL;
	Vector*  ys  = NULL;
	int  configuration_type;

	/*Recover parameters: */
	femmodel->parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	UpdateConstraintsx(femmodel->nodes,femmodel->constraints,femmodel->parameters);

	SystemMatricesx(&Kff, &Kfs, &pf, &df, NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	CreateNodalConstraintsx(&ys,femmodel->nodes,configuration_type);
	Reduceloadx(pf, Kfs, ys); xdelete(&Kfs);
	Solverx(&uf, Kff, pf, NULL, df, femmodel->parameters); 
	xdelete(&Kff); xdelete(&pf); xdelete(&df);
	Mergesolutionfromftogx(&ug, uf,ys,femmodel->nodes,femmodel->parameters);xdelete(&uf); xdelete(&ys);
	InputUpdateFromSolutionx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,ug); 
	xdelete(&ug);  xdelete(&uf);
}
