/*!\file: elements.h
 * \brief prototypes for elements.h
 */ 

#ifndef _SHARED_ELEMENTS_H_
#define  _SHARED_ELEMENTS_H_

#include "../../objects/objects.h"
#include "../../Container/Container.h"
class ElementMatrix;
class ElementVector;

double Paterson(double temperature);
double Arrhenius(double temperature,double depth,double n);
void   GetVerticesCoordinates(double* xyz,  Node** nodes, int numvertices);
int    GetNumberOfDofs( Node** nodes,int numnodes,int setenum,int approximation_enum);
int*   GetLocalDofList( Node** nodes,int numnodes,int setenum,int approximation_enum);
int*   GetGlobalDofList(Node** nodes,int numnodes,int setenum,int approximation_enum);
#ifdef _HAVE_DIAGNOSTIC_
void   CoordinateSystemTransform(double** ptransform,Node** nodes,int numnodes,int* cs_array);
void   TransformInvStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int cs_enum);
void   TransformInvStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int* cs_array);
void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int cs_enum);
void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int* cs_array);
void   TransformLoadVectorCoord(ElementVector* pe,Node** nodes,int numnodes,int cs_enum);
void   TransformLoadVectorCoord(ElementVector* pe,Node** nodes,int numnodes,int* cs_array);
void   TransformSolutionCoord(double* solution,Node** nodes,int numnodes,int cs_enum);
void   TransformSolutionCoord(double* solution,Node** nodes,int numnodes,int* cs_array);
#endif

inline void printarray(double* array,int lines,int cols=1){
	printf("\n");
	for(int i=0;i<lines;i++){  
		printf("   [ ");
		for(int j=0;j<cols;j++) printf(" %12.7g ",array[i*cols+j]);
		printf(" ]\n");
	}  
	printf("\n");
}
inline void printarray(int* array,int lines,int cols=1){
	printf("\n");
	for(int i=0;i<lines;i++){  
		printf("   [ ");
		for(int j=0;j<cols;j++) printf(" %6i",array[i*cols+j]);
		printf(" ]\n");
	}  
	printf("\n");
}

#endif //ifndef _SHARED_ELEMENTS_H_
