/*\file Reducevectorgtos.c
 *\brief: reduce g set vector to s set vector (set of single point constraints)
 */

#include "./Reducevectorgtos.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vector* yg=NULL;
	Nodes* nodes=NULL;
	Parameters* parameters=NULL;

	/* output datasets: */
	Vector* ys=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ReducevectorgtosUsage);

	/*Input datasets: */
	FetchMatlabData(&yg,YG);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData(&parameters,PARAMETERS);

	/*!Reduce vector: */
	Reducevectorgtosx(&ys,yg,nodes,parameters);

	/*write output datasets: */
	WriteMatlabData(YS,ys);

	/*Free ressources: */
	delete nodes;
	delete parameters;
	delete yg;
	delete ys;

	/*end module: */
	MODULEEND();
}

void ReducevectorgtosUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: ys = %s(yg,nodes,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
