#This installs the Android SDK (Software Development Kit)
#which is needed for the compilation of the Java project. 

step=1;

#Different steps here. 
#1: install sdk, ant and sdk tools
#2: install an emulator.
#3: test the emulator
#4: cleanup

present_dir=`pwd`;

if [[ $step == "1" ]]; then

	#Cleanup the install
	rm -rf install-sdk install-ant

	# Install Android SDK and NDK.
	unzip -o android-sdk-r16-macosx.zip
	unzip -o apache-ant-1.8.2-bin.zip

	#Move to install
	mv android-sdk-macosx install-sdk
	mv apache-ant-1.8.2 install-ant

	#Post_install configuration: 
	#We need specific settings for specific platforms, for the SDK to 
	#function properly

	#For now, we need to install:  
	#android sdk platform tools  
	#a specific android api: API 15

	cd install-sdk/tools/ && source ./android
fi

if [[ $step == "2" ]]; then

	#Once this is done, we need to install an emulator. Location will default to ~/.android/avd, 
	#which we will move to $ISSM_TIER/externalpackages/android-emulators.  
	#For now, it's called: Android-4.0.3

	cd $present_dir/install-sdk/tools
	./android avd
	mv ~/.android/avd/Android-4.0.3.*  $ISSM_TIER/externalpackages/android-emulators

fi


if [[ $step == "3" ]]; then
	
	cd $present_dir/install-sdk/platform-tools
	./adb -p "$ISSM_TIER/externalpackages/android-emulators" devices

fi

if [[ $step == "4" ]]; then
	rm -rf install-sdk install-ant
fi
