/*!\file:  Vector.h
 * \brief wrapper to vector objects. The goal is to control which API (PETSC,Scalpack, Plapack?) 
 * implements our underlying vector format.
 */ 

#ifndef _VECTOR_H_
#define _VECTOR_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "../Object.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#ifdef _HAVE_ADOLC_
#include "adolc.h"
#endif
		

#ifdef _SERIAL_
#include "mex.h"
#endif

/*}}}*/

class Vector{

	public:
	
		int M;

		#ifdef _HAVE_PETSC_
		Vec vector; 
		#else
		double* vector; 
		#endif
		#ifdef _HAVE_ADOLC_
		adouble* avector;
		#endif

		/*Vector constructors, destructors {{{1*/
		Vector();
		Vector(int M,bool fromlocalsize=false);
		~Vector();
		/*}}}*/
		/*Vector specific routines {{{1*/
		void Echo(void);
		#ifdef _SERIAL_
		mxArray* ToMatlabVector(void);
		#endif
		/*}}}*/
};
#endif //#ifndef _VECTOR_H_
