/*!\file Vector.cpp
 * \brief: implementation of the Vector object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
#include "./Vector.h"
/*}}}*/

/*Vector constructors and destructor*/
/*FUNCTION Vector::Vector(){{{1*/
Vector::Vector(){

	#ifdef _HAVE_PETSC_
	this->vector=NULL;
	#else
	this->vector=NULL;
	this->M=0;
	#endif
	#ifdef _HAVE_ADOLC_
	this->avector=NULL;
	#endif
}
/*}}}*/
/*FUNCTION Vector::Vector(int M,bool fromlocalsize){{{1*/
Vector::Vector(int pM,bool fromlocalsize){

	#ifdef _HAVE_PETSC_
	this->vector=NewVec(pM,fromlocalsize);
	#else
	this->M=pM;
	this->vector=(double*)xcalloc(pM,sizeof(double));
	#endif
	#ifdef _HAVE_ADOLC_
	this->avector=(adouble*)xmalloc(pM*sizeof(adouble));
	#endif
}
/*}}}*/
/*FUNCTION Vector::~Vector(){{{1*/
Vector::~Vector(){

 	#ifdef _HAVE_PETSC_
	VecFree(&this->vector);
	#else
	xfree((void**)&this->vector);
	#endif
	#ifdef _HAVE_ADOLC_
	xfree((void**)&this->avector);
	#endif
}
/*}}}*/

/*Vector specific routines: */
/*FUNCTION Vector::Echo{{{1*/
void Vector::Echo(void){

	int i;

	#ifdef _HAVE_PETSC_
	VecView(this->vector,PETSC_VIEWER_STDOUT_WORLD);
	#else
	printf("Vector size: %i\n",M);
	for(i=0;i<M;i++){
		printf("%g\n ",*(vector+i));
	}
	#endif

	#ifdef _HAVE_ADOLC_
	/*Not sure about that one. Should we use the overloaded operator >>?*/
	printf("ADOLC Vector equivalent:" );
	for(i=0;i<M;i++){
		printf("%g\n ",*(avector+i));
	}
	#endif
}
/*}}}*/

#ifdef _SERIAL_
/*FUNCTION Vector::ToMatlabVector{{{1*/
mxArray* Vector::ToMatlabVector(void){

	mxArray* dataref=NULL;
	#ifdef _HAVE_PETSC_
	PetscVectorToMatlabVector(&dataref,this->vector);
	#else
	_error_("not implemented yet!");
	#endif

}
/*}}}*/
#endif
