#!/bin/bash
#Synchronize EnumToStringx.cpp and StringToEnumx.cpp and matlab Enums

#Get all lines of EnumDefinitions2.h which hold Enum | remove all comas | add line number in the first column > put everything in file temp
cat EnumDefinitions.h | grep -e "[0-9]Enum," -e "[a-zA-Z]Enum," | grep -v include | sed -e "s/,//g" | awk '{ printf "%s %s\n", NR, $0 }' > temp

#Removed existing files
rm $ISSM_TIER/src/m/enum/*.m
rm $ISSM_TIER/src/c/modules/EnumToStringx/EnumToStringx.cpp
rm $ISSM_TIER/src/c/modules/StringToEnumx/StringToEnumx.cpp

#Get number of enums
NUMENUMS=$(wc -l temp | awk '{printf("%s",$1);}');

#Build EnumToStringx.cpp {{{1
#Header
cat <<END >  $ISSM_TIER/src/c/modules/EnumToStringx/EnumToStringx.cpp
/*
* \file EnumToStringx.cpp:
* \brief: output string associated with enum
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by Synchronize.sh
*            Please read README for more information
*/

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "./EnumToStringx.h"

const char* EnumToStringx(int en){

	switch(en){

END
#core
cat temp |  awk '{print "\t\t" "case " $2" : return \"" substr($2,1,length($2)-4) "\";"}' >> $ISSM_TIER/src/c/modules/EnumToStringx/EnumToStringx.cpp
#Footer
cat <<END >> $ISSM_TIER/src/c/modules/EnumToStringx/EnumToStringx.cpp
		default : return "unknown";

	}
}
void EnumToStringx(char** pstring,int enum_in){
	char *string = NULL;
	int   len = 0;

	len=strlen(EnumToStringx(enum_in));
	string=(char*)xmalloc((len+1)*sizeof(char));
	memcpy(string,EnumToStringx(enum_in),(len+1)*sizeof(char));

	/*Assign output pointer*/
	*pstring=string;
}
END
#}}}
#Build StringToEnumx.cpp {{{1
#Header
cat <<END > $ISSM_TIER/src/c/modules/StringToEnumx/StringToEnumx.cpp
/*
* \file StringToEnumx.cpp:
* \brief: output enum associated with string
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by Synchronize.sh
*            Please read README for more information
*/

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "./StringToEnumx.h"

int  StringToEnumx(const char* name){

   int  stage=1;

END

#core
i1=1;
i2=120;
for (( i=1 ; i<=100 ; i++ )); do
	echo "   if(stage==$i){" >> $ISSM_TIER//src/c/modules/StringToEnumx/StringToEnumx.cpp
	awk -v i1=$i1 -v i2=$i2 '{if(NR>=i1 && NR<=i2) print $0 }' temp |
	awk '{print "\t" ((NR==1)?"      if":"      else if") " (strcmp(name,\"" substr($2,1,length($2)-4) "\")==0) return " $2 ";"}' >> $ISSM_TIER//src/c/modules/StringToEnumx/StringToEnumx.cpp
	echo "         else stage=$(($i+1));" >> $ISSM_TIER//src/c/modules/StringToEnumx/StringToEnumx.cpp
	echo "   }" >> $ISSM_TIER//src/c/modules/StringToEnumx/StringToEnumx.cpp
	
	if [ $i2 -ge $NUMENUMS ]; then break; fi
	let i1=$i1+120
	let i2=$i2+120
done

#footer
cat <<END >> $ISSM_TIER/src/c/modules/StringToEnumx/StringToEnumx.cpp
	/*If we reach this point, the string provided has not been found*/
   _error_("Enum %s not found",name);
}
END
#}}}

# go through the lines of temp
for (( i=1 ; i<=$NUMENUMS ; i++ )); do

	#Get name and enum of the line i
	NAMEENUM=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$2);}');
	NAME=$(echo $NAMEENUM | sed -e "s/Enum//g")
	ENUM=$i;
	#offset Enum by one (Enum begins with 0 and not 1!)
	let ENUM=$ENUM-1

	#print info {{{
	if [ $i -lt 10 ]
	then
		printf "\r                                                                      "
		printf "\r  $i/$NUMENUMS Adding "$NAME"..."
	else
		if [ $i -lt 100 ]
		then
			printf "\r                                                                      "
			printf "\r $i/$NUMENUMS Adding "$NAME"..."
		else
			printf "\r                                                                      "
			printf "\r$i/$NUMENUMS Adding "$NAME"..."
		fi
	fi
	#}}}
	#Add case to matlabenum file{{{
	cat <<END > $ISSM_TIER"/src/m/enum/"$(echo $NAMEENUM".m")
function macro=$(echo $NAMEENUM)()
%$(echo $NAMEENUM | awk {'print toupper($1)'}) - Enum of $(echo $NAME)
%
%   WARNING: DO NOT MODIFY THIS FILE
%            this file has been automatically generated by src/c/EnumDefinitions/Synchronize.sh
%            Please read src/c/EnumDefinitions/README for more information
%
%   Usage:
%      macro=$NAMEENUM()

macro=StringToEnum('$NAME');
END
#}}}

done

#clean up{{{
rm temp
#}}}
#print info {{{
printf "\r                                                                      "
printf "\rdone!\n"
#}}}
