% This file can be run to check that the current version of macayeal and issm models are giving 
% coherent results. This test deals with an icesheet without icefront for a 2d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup ISSM code. 
% The results of this test will indicate if there is a difference between current computations 
% and archived results.

% Errors  between archived results and the current version will get flagged if they are not within 
% a certain tolerance. The current tolerance is 10^-14. If you have good reasons to believe this 
% tolerance should be lowered (for example, if you are running single precision compilers?), feel 
% free to tweak the tolerance variable.

%packages and solutions to be tested
packages={'macayeal','ice','cielo_serial','cielo_parallel'};

%Initialize log message for nightly runs.
testname='IceSheetNoIceFront2d_1';
tolerance=10^-12;

%go through the solutions requested
for i=1:length(packages),
	package=packages{i};

	%initialize model
	md=model;
	md=mesh(md,'DomainOutline.exp',50000);
	md=geography(md,'','');
	md=parameterize(md,'Square.par');
	md=setelementstype(md,'macayeal','all');

	%Compute solution using requested package
	if strcmpi(package,'macayeal'),

		%DIAGNOSTIC
		md=solve(md,'diagnostic','macayeal');
		%check result
		load ArchiveMacAyealDiag
		pos=find(ArchiveMacAyealDiag); error_vel=abs(norm((ArchiveMacAyealDiag(pos)-md.vel(pos))./ArchiveMacAyealDiag(pos),2));
		if (error_vel>tolerance);
			disp(['test: ' testname  ', solution: diagnostic, package: ' package ' -> ERROR (difference=' num2str(error_vel) ')'])
		else
			disp(['test: ' testname  ', solution: diagnostic, package: ' package ' -> SUCCESS (difference=' num2str(error_vel) ')'])
		end

	elseif strcmpi(package,'ice'),

		%DIAGNOSTIC
		md=solve(md,'diagnostic','ice');
		%check result
		load ArchiveIceDiag
		pos=find(ArchiveIceDiag); error_vel=abs(norm((ArchiveIceDiag(pos)-md.vel(pos))./ArchiveIceDiag(pos),2));
		if (error_vel>tolerance);
			disp(['test: ' testname  ', solution: diagnostic, package: ' package ' -> ERROR (difference=' num2str(error_vel) ')'])
		else
			disp(['test: ' testname  ', solution: diagnostic, package: ' package ' -> SUCCESS (difference=' num2str(error_vel) ')'])
		end

	elseif strcmpi(package,'cielo_serial'),

		%DIAGNOSTIC
		md=solve(md,'diagnostic','cielo');
		%check result
		load ArchiveCieloSerialDiag
		pos=find(ArchiveCieloSerialDiag); error_vel=abs(norm((ArchiveCieloSerialDiag(pos)-md.vel(pos))./ArchiveCieloSerialDiag(pos),2));
		if (error_vel>tolerance);
			disp(['test: ' testname  ', solution: diagnostic, package: ' package ' -> ERROR (difference=' num2str(error_vel) ')'])
		else
			disp(['test: ' testname  ', solution: diagnostic, package: ' package ' -> SUCCESS (difference=' num2str(error_vel) ')'])
		end

	elseif strcmpi(package,'cielo_parallel'),

		%DIAGNOSTIC
		md.cluster='wilkes';
		md=solve(md,'diagnostic_horiz','cielo');
		%check result
		load ArchiveCieloParallelDiag
		pos=find(ArchiveCieloParallelDiag); error_vel=abs(norm((ArchiveCieloParallelDiag(pos)-md.vel(pos))./ArchiveCieloParallelDiag(pos),2));
		if (error_vel>tolerance);
			disp(['test: ' testname  ', solution: diagnostic, package: ' package ' -> ERROR (difference=' num2str(error_vel) ')'])
		else
			disp(['test: ' testname  ', solution: diagnostic, package: ' package ' -> SUCCESS (difference=' num2str(error_vel) ')'])
		end

	else
		disp(sprintf(['\npackage ' package  ' not supported yet.\n']));
	end
end
