#/bin/bash

#Package using the Package Maker from OSX, driven by command line.
echo "Cleanup first" 
sudo sh -c "rm -rf ISSM-MacOSX.pkg bin test"

#We need to copy all the relevant files and set the permissions, as PackageMaker 
#is not good at that. 
echo "Copy bin" 
cp -Rf $ISSM_TIER/bin ./
echo "Copy test" 
cp -Rf $ISSM_TIER/test ./
cp matlabissm startup.m ./bin

#Now change group and ownership: 
echo "Change group and ownership" 
sudo sh -c "chown -R root ./bin && chgrp -R admin ./bin"
sudo sh -c "chown -R root ./test && chgrp -R admin ./test"

echo "Launch packagemaker" 
PackageMaker -d ISSM.pmdoc -o ISSM-MacOSX.pkg

#cleanup
echo "Final cleanup"
sudo sh -c "rm -rf ./bin && rm -rf ./test"
