#!/bin/bash

#Some cleanup
rm -rf src install mpich2-1.4
mkdir src install

#Untar 
tar -zxvf  mpich2-1.4.tar.gz

#Move mpich2 into src directory
mv mpich2-1.4/* src
rm -rf mpich2-1.4

#Configure mpich2
cd src
export FFLAGS=" -m32"
export CFLAGS=" -m32"
export CXXFLAGS=" -arch i386"
export CPPFLAGS=" -arch i386"
./configure \
	--prefix="$ISSM_TIER/externalpackages/mpich2/install" \
	--enable-f91=gfortran \
	--enable-sharedlibs=osx-gcc \
	--enable-shared \
	--enable-fc

#Compile mpich2
if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install 

#remove so files
cd ../install/lib
rm -rf *.so
